# Example Micro-Frontend Studio Client Plugin

## Build it

### `pnpm install`
### `pnpm -r build`

## Integrate The Plugin Into a Local Studio Client CMS Workspace

Suppose you have a Studio Client workspace checked out in folder `$STUDIO_CLIENT_ROOT` and you have built the whole Studio Client in the usual way (`pnpm install` -> `pnpm -r build`).  

Suppose you have the example plugin in folder `$EXAMPLE_MICROFRONTEND_PLUGIN_ROOT`.

In the file `$STUDIO_CLIENT_ROOT/apps/main/blueprint/app/jangaroo.config.js`, where `module.exports = jangarooConfig({ ... })` is defined, you add this line to the `additionalPackagesDirs` array:

```javascript
    "$EXAMPLE_MICROFRONTEND_PLUGIN_ROOT/apps/main/example-microfrontend-extjs",
```

Afterwards, you only have to re-build the package `@coremedia-blueprint/studio-client.main.app` (for example by manually tiggering the build script from the `package.json`) and (re-)start the Studio Client:

```javascript
    // (leave out 'blueprint' if you are working with a Blueprint workspace)
    cd $STUDIO_CLIENT_ROOT/global/studio/blueprint
    // use a remote Studio Url instead of localhost if needed, e.g. https://studio.release-ci-cms-9999.coremedia.vm/
    pnpm run start --proxyTargetUri=http://localhost:41080
```

From here on, as long as you only make changes to the example plugin workspace, you only have to re-build the plugin.
