import React from "react";
import { WebComponentBase } from "./WebComponentBase";
import { ReactExamplePropertyField } from "./ReactExamplePropertyField";

export class ExamplePropertyFieldWebComponent extends WebComponentBase {
  protected render() {
    if (this.root) {
      this.root.render(<ReactExamplePropertyField uuid={this.uuid} />);
    }
  }

  get uuid(): string {
    return this.getAttribute("uuid") ?? "";
  }

  static get observedAttributes(): string[] {
    return ["uuid"];
  }
}

customElements.define("example-property-field-web-component", ExamplePropertyFieldWebComponent);
