import type { Root } from "react-dom/client";
import { createRoot } from "react-dom/client";

export abstract class WebComponentBase extends HTMLElement {
  #root?: Root;
  readonly #shadowContainer: ShadowRoot;
  #shadowRootElement: HTMLDivElement;

  constructor() {
    super();
    const shadowRootElement = document.createElement("div");
    shadowRootElement.style.height = "100%";

    this.#shadowContainer = this.attachShadow({ mode: "open" });
    this.#shadowRootElement = shadowRootElement;
    this.#shadowContainer.appendChild(shadowRootElement);
  }

  connectedCallback() {
    this.#root = createRoot(this.#shadowRootElement);
    this.render();
  }

  attributeChangedCallback() {
    this.render();
  }

  disconnectedCallback() {
    this.#root = undefined;
  }

  protected get root(): Root | undefined {
    return this.#root;
  }

  protected get shadowRootElement(): HTMLDivElement {
    return this.#shadowRootElement;
  }

  protected get shadowContainer(): ShadowRoot {
    return this.#shadowContainer;
  }

  protected abstract render(): void;
}
