import { ExamplePropertyFieldWebComponent } from "./ExamplePropertyFieldWebComponent";

export type PropertyFieldConfig = {
  id: string;
  label: string;
  factory: () => HTMLElement;
};

export type AddCmArticlePropertyFieldExtension = {
  addCmArticlePropertyField(fieldConfig: PropertyFieldConfig): void;
};

export const initPlugin = async (extension: AddCmArticlePropertyFieldExtension) => {
  extension.addCmArticlePropertyField({
    id: "example-microfrontend-field",
    label: "Hello Micro-Frontend Field",
    factory: () => new ExamplePropertyFieldWebComponent(),
  });
};
